<?php
include 'koneksi.php';
include 'header1.php';

// Ambil data bobot dari tabel bobot1
$query = "SELECT * FROM bobot1 LIMIT 1";
$result = mysqli_query($conn, $query);
$bobot = mysqli_fetch_assoc($result);
?>

<div id="layoutSidenav_content">
    <main>
    <div class="table-responsive">
        <div class="container-fluid mt-4">
            <h3 class="text-center mb-10 py-4 bg-light rounded" style="font-size: 28px; ">
                <strong> CRITERIA AND WEIGHTS</strong> 
            </h3>

            <?php if (!$bobot) : ?>
                <div class="alert alert-danger text-center" style="font-size: 17px;">
                    <strong>Weight data not found!</strong> Please define the weight values first.
                </div>
            <?php else : ?>
                    <div class="alert alert-info text-center mb-3 bg-primary text-white" style="font-size: 20px;">
                    <i class="fas fa-info-circle"></i>  <strong>Level of Importance = </strong> 
                            5 : Very Important | 4 : Important | 3 : Important Enough | 2 : Less Important | 1 : Not Important
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered text-center w-100" style="font-size: 20px;">
                                <thead class="table-primary align-middle">
                                     <tr style="height: 100px;">
                                        <th>Code</th>
                                        <th>Criteria</th>
                                        <th>Weight</th>
                                        <th>Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $kriteria = [
                                        "C1" => "Content Relevance",
                                        "C2" => "Quality of Delivery",
                                        "C3" => "Audiovisual Quality",
                                        "C4" => "Interactivity & Engagement",
                                        "C5" => "Frequency of Use",
                                        "C6" => "Access Barriers",
                                        "C7" => "Impact on Understanding"
                                    ];
                                    $tipe = [
                                        "C1" => "Benefit",
                                        "C2" => "Benefit",
                                        "C3" => "Benefit",
                                        "C4" => "Benefit",
                                        "C5" => "Benefit",
                                        "C6" => "Cost",
                                        "C7" => "Benefit"
                                    ];

                                    foreach ($kriteria as $key => $nama_kriteria) :
                                        $nilai_bobot = isset($bobot[strtolower($key)]) ? $bobot[strtolower($key)] : "Data not found";
                                    ?>
                                    
                                         <tr style="height: 90px">
                                            <td class="align-middle"><?= $key; ?></td>
                                            <td class="align-middle"><?= $nama_kriteria; ?></td>
                                            <td class="align-middle"><?= $nilai_bobot; ?></td>
                                            <td class="align-middle"><?= $tipe[$key]; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <br>

            <div class="text-center">
                <?php if (!$bobot) : ?>
                    <a href="ubah_bobot1.php" class="btn btn-lg btn-success" style="font-size: 18px; padding: 12px 24px;">
                        <i class="fas fa-plus"></i> Determine Criteria Weight Values
                    </a>
                <?php else : ?>
                    <a href="ubah_bobot1.php" class="btn btn-lg btn-warning" style="font-size: 22px; padding: 12px 24px;">
                        <i class="fas fa-edit"></i> Modify Weight
                    </a>
                <?php endif; ?>
            </div>

        </div>
    </main>
</div>

<!-- Pastikan navigasi bisa dibuka dan tidak macet -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>
